--------------------------------------------------------------------
--            SymCACP script-Holstein-CB-Boundary      
-- Symmetrical CA Control Panel   symCACPscript-1
-- file for Holstein Checkerboad vertical boundries
--------------------------------------------------------------------
--  P. Rendell   19/10/2023
--------------------------------------------------------------------

--==============================================================================
------------------------------------------------------------

local scriptType = "script-Holstein-CB-Boundary"
local m={}			-- class table
local comProcs			-- common Procedures
local g = golly()
local scriptFileData
local logFile
local logDiverted
m.colonList = {}
m.equalList = {['NONE'] = {'d',""}}

local noRunLengs = {}
local maxRunLeng = {}

------------------------------------------------------------------------------------------------

m.ht = 35
m.wd = 35
m.wd0= -17
m.wd1 = 17
--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
   logDiverted = false
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==================================================================

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------
--==============================================================================
--==============================================================================
------------------------------------------------------------

function incX(x)
   local nx = x+1
   if (nx > m.wd1) then
      nx = m.wd0
   end
   return(nx)
end
------------------------------------------------------------

function incY(y)
   local ny = y+1
   if (ny > m.ht1 ) then
      ny = m.ht0
   end
   return(ny)
end
------------------------------------------------------------

function addX(x,inc)
   return((x+inc-m.wd0)%m.wd + m.wd0)
end
------------------------------------------------------------

function addY(y,inc)
   return((y+inc-m.ht0)%m.ht + m.ht0)
end
------------------------------------------------------------

function decX(x)
   local nx = x-1
   if (nx <  m.wd0) then
      nx = m.wd1
   end
   return(nx)
end
------------------------------------------------------------

function decY(y)
   local ny = y-1
   if (ny < m.ht0) then
      ny = m.ht1
   end
   return(ny)
end
------------------------------------------------------------

local function gapX(a,b)
   local gap = math.max(a,b) - math.min(a,b)
   return (math.min(gap, m.wd - gap))
end
------------------------------------------------------------

local function scanY(y)
   g.setlayer(m.uniLay)
   g.setlayer(m.stainLay)
end
------------------------------------------------------------

local function setBoundry(x,y)
   local lay = g.getlayer()
   g.setlayer(m.stainLay)
   g.show("sb x "..x.." sb y "..y)
   g.setcell(x, y, 1)
   g.setcell(x, -1-y, 1)
   g.setcell(incX(x)  , y, 1)
   g.setcell(incX(x)  , -1-y, 1)
   g.setlayer(lay)
end
------------------------------------------------------------
--   special case of oscillator left after blowoff. This leaves rows of 2 and 4 cells 
--   detect by Rl >2 RL 4/2 Rl >2
--   example H1E8  w/H 60 seed 1012 gen 65
--   Worse case same pattern on its side. This is much more difficult *****
---  example H1E8 w/h 80 seed 1012 gen 335

local function findRunLengs(y)
   local started = false
   local x = m.wd0
   local x0 = x-1
   local rlX = x
   local state= g.getcell(x,y)
   local runLeng= 0
   local oldState = state
   local runLengs = {}
   local catchCNT = 2*m.wd+1
   local oscTestState = 0
   --.....................................................
   function oscTest(ind)
      local result = false
      if (#runLengs-ind > 2) then
         if (runLengs[#runLengs-2].RL > 2) and 
            ((runLengs[#runLengs-1].RL < 3) or (runLengs[#runLengs-1].RL == 4)) and 
            (runLengs[#runLengs].RL > 2) then
            result = true
            logFile:write("##findRunLengs(2) oscTest "..(runLengs[#runLengs-2].X)..","..y.." old leng "..#runLengs)
            runLengs[#runLengs-2].RL = runLengs[#runLengs-2].RL + runLengs[#runLengs-1].RL + runLengs[#runLengs].RL
            runLengs[#runLengs] = nil
            runLengs[#runLengs] = nil
            logFile:write(" ## new leng "..#runLengs.."\n")
         end
      end
      if (#runLengs-ind > 4) then
         if (runLengs[#runLengs-4].RL > 2) and (runLengs[#runLengs-3].RL == 1) and (runLengs[#runLengs-2].RL == 1) and 
            (runLengs[#runLengs-1].RL == 1) and (runLengs[#runLengs].RL > 2) then
            result = true
            logFile:write("##findRunLengs(4) oscTest "..(runLengs[#runLengs-4].X)..","..y.." old leng "..#runLengs)
            runLengs[#runLengs-4].RL = runLengs[#runLengs-4].RL + 3 + runLengs[#runLengs].RL
            runLengs[#runLengs] = nil
            runLengs[#runLengs] = nil
            runLengs[#runLengs] = nil
            runLengs[#runLengs] = nil
            logFile:write(" ## new leng "..#runLengs.."\n")
         end
      end
      return(result)
   end
   --.....................................................
   function oscTestLast()
      local ind = 1
      if(#runLengs > 4) then
         runLengs[#runLengs+1] = runLengs[1]
         logFile:write("oscTestLast RLs: "..#runLengs.." runLengs[1].X "..runLengs[1].X.."\n")
         runLengs[1] = nil
         oscTest(1)
         runLengs[#runLengs+1] = runLengs[2]
         runLengs[2] = nil
         oscTest(2)
         runLengs[#runLengs+1] = runLengs[3]
         runLengs[3] = nil
         oscTest(3)
         runLengs[#runLengs+1] = runLengs[4]
         runLengs[4] = nil
         oscTest(4)
         for i,rl in pairs(runLengs) do
            runLengs[ind] = rl
            runLengs[i] = nil
            ind = ind+1
         end
         logFile:write("##oscTestLast(a) new leng "..#runLengs.."\n")
      elseif(#runLengs > 3) then
         runLengs[#runLengs+1] = runLengs[1]
         runLengs[1] = nil
         oscTest(1)
         runLengs[#runLengs+1] = runLengs[2]
         runLengs[2] = nil
         oscTest(2)
         for i,rl in pairs(runLengs) do
            runLengs[ind] = rl
            runLengs[i] = nil
            ind = ind+1
         end
         logFile:write("##oscTestLast(b) new leng "..#runLengs.."\n")
      end
   end
   --....................................................
   logFile:write("##findRunLengs -1,-1 "..g.getcell(-1,-1).." 0,-1 "..g.getcell(0,-1).."\n")
   local rawCNT = 0
   while (x ~= x0) do
      logFile:write("##findRunLengs "..x..","..y.." x0="..x0.." state "..state.." #runLengs="..#runLengs.."\n")
      if (oldState == state) then 
         runLeng = runLeng +1
      else
         if (not started) then
            started = true
            x0 = x
         else
            runLengs[#runLengs+1] = {['X'] = rlX, ['ST'] = state, ['RL'] = runLeng}
            logFile:write("##findRunLengs ++ "..x..","..y.." x0="..x0.." state "..state.." #runLengs="..#runLengs.."\n")
            oscTest(0)
         end
         rawCNT = rawCNT +1
         runLeng = 1
         rlX = x
         oldState = state
      end
      x = addX(x,1)
      state= g.getcell(x,y)
      catchCNT = catchCNT -1
      if (catchCNT < 0) then
         logFile:write("**findRunLengs loop cought")
         x0 = x
      end
   end
   runLengs[#runLengs+1] = {['X'] = rlX, ['ST'] = state, ['RL'] = runLeng}
   logFile:write("##findRunLengs ++ "..x..","..y.." x0="..x0.." state "..state.." #runLengs="..#runLengs.."\n")
   rawCNT = rawCNT +1
   oscTest(0)
   oscTestLast()
   return({runLengs, rawCNT})
end
------------------------------------------------------------

local function logRunLengs(y, runLengs)
   logFile:write(#runLengs.." Run Lengths @ y="..y.." \n")
   for i = 1, #runLengs do
      logFile:write(runLengs[i].X.."\t="..runLengs[i].ST..":"..runLengs[i].RL.."\n")      
   end
end
------------------------------------------------------------

local function findBoundry(y)
   local longRunEnds = {}
   local rl = findRunLengs(y)
   local runLengs = rl[1]
   local rawCnt = rl[2]
   logRunLengs(y, runLengs)
   local states = {}
   
   
   local maxRL = 0
   for i,rl in pairs(runLengs) do
      logFile:write("##ST "..rl.ST.."\t X"..rl.X.."\t RL "..rl.RL.."\n")
      if (not longRunEnds[rl.ST]) then
         states[#states+1] = rl.ST
         longRunEnds[rl.ST] = {['L'] = rl.X, ['R'] = addX(rl.X, rl.RL-1), ['RL'] = rl.RL}
      elseif (longRunEnds[rl.ST].RL < rl.RL) then
         longRunEnds[rl.ST] = {['L'] = rl.X, ['R'] = addX(rl.X, rl.RL-1), ['RL'] = rl.RL}
      end
      maxRL = math.max(maxRL,runLengs[i].RL)
   end

   noRunLengs[y] = rawCnt
   maxRunLeng[y] = maxRL

   logFile:write("##findBoundry:Test m.wd ="..m.wd.." m.wd1="..m.wd1.." incX -1="..incX(m.wd1-1).." addX(1-1)="..addX(m.wd1-1,1).."\n")
   logFile:write("##findBoundry:Test m.wd ="..m.wd.." m.wd1="..m.wd1.." incX="..incX(m.wd1).." addX(1)="..addX(m.wd1,1).."\n")
   -- find the width of gaps between longruns
   local finished = false
   local i = 1
   local rl, counting
   local catchCNT=500
   while(not finished) do
      rl = runLengs[i]
      logFile:write("##findBoundry runleng x "..rl.ST.."\n")
      if (rl.X == longRunEnds[rl.ST].L) then
         finished = (longRunEnds[rl.ST].GAP)
         if (not finished) then
            longRunEnds[rl.ST].GAP = 0
            counting = longRunEnds[rl.ST]
            logFile:write("##findBoundry start counting "..rl.ST.."\n")
         end         
      elseif (counting) then
         counting.GAP = counting.GAP + rl.RL
         logFile:write("##findBoundry  counting "..rl.ST.." is "..counting.GAP.."\n")
      end
      i = (i%#runLengs)+1
      catchCNT = catchCNT-1
      if (catchCNT < 0) then
         finished = true
         logFile:write("##findBoundry loop cought")
      end
   end
   for i,rlEnd in pairs(longRunEnds) do
      rlEnd.boundry = addX(rlEnd.R,rlEnd.GAP/2)
      logFile:write("##findBoundry: state: "..i.." Left:"..rlEnd.L.." Right;"..rlEnd.R.." Gap="..rlEnd.GAP.." Boundry ="..rlEnd.boundry.."\n")
      setBoundry(math.floor(rlEnd.boundry), y)
   end
end

--==============================================================================
--==============================================================================


function m.run(segmentNo)

   ---------------------  script data -----------------------
   --   none
   ---------------------------------------------------------
   logFile:write("\nRun Holstein-CB-Boundary\n\n")
   local stainLayName = "Stain"
   m={}
   m.ht = tonumber(g.getwidth())
   m.wd = tonumber(g.getheight())
   m.ht0 =  -(m.ht//2)
   m.ht1 = (m.ht-1)//2 
   m.wd0 =  -(m.wd//2)
   m.wd1 = (m.wd-1)//2 

   a = m.wd0+4
   b = m.wd1-2
   logFile:write("## test gap: gapX("..a..","..b..") "..gapX(a, b).."\n")
   logFile:write("## test gap: gapX("..b..","..a..") "..gapX(b, a).."\n\n")

   m.border = {}
   local yStart = -m.ht1//2
   m.border[0] = {['x'] = decX(m.wd0), ['y'] = yStart }
   m.border[1] = {['x'] = decX(0),     ['y'] = yStart }
   m.uniLay = g.getlayer()
   g.setlayer(g.numlayers()-1)
   if (g.getname() == stainLayName) then
      g.dellayer()
   end
   m.stainLay = g.addlayer()
   g.setname(stainLayName)
   g.setgen(g.getgen())
   g.setcolors({1,255,0,0})

   g.select({0,0,1,1})
   g.clear(1)
   g.clear(0)
   g.select({})

   g.setlayer(m.uniLay)
   for i = m.ht0, m.ht1 do
      findBoundry(i)
   end

   logFile:write("## "..#noRunLengs.."\n")
   for i = m.ht0, m.ht1 do
      logFile:write("##findBoundry y="..i.." No Runlengs ="..(noRunLengs[i]).."\t maxRL="..(maxRunLeng[i]).."\n")
   end
   logFile:write("##\n")
   
   g.setlayer(m.uniLay)
end   
return m
------------------------------------------------------------
------------------------------------------ eof -----------------------------------------
